CREATE DATABASE GrafikUczelniPrzyklad
GO

use GrafikUczelniPrzyklad
GO

CREATE TABLE Budynki (
	KodBudynku nvarchar (3) NOT NULL ,
	NazwaBudynku nvarchar (25) NULL ,
	LiczbaKondygnacji smallint NULL ,
	Winda bit NOT NULL ,
	Parking bit NOT NULL 
)
GO

CREATE TABLE Dziedziny (
	IDDziedziny nvarchar (10) NOT NULL ,
	OpisDziedziny nvarchar (75) NULL ,
	IDWydzialu int NULL 
)
GO

CREATE TABLE Sale (
	IDSali int NOT NULL ,
	KodBudynku nvarchar (3) NULL ,
	DostTelefonu bit NOT NULL , 
	LiczbaMiejsc smallint NOT NULL 
)
GO

CREATE TABLE Zajecia (
	IDZajec int NOT NULL ,
	IDPrzedmiotu int NULL ,
	IDSali int NULL ,
	PunktyEdukacyjne tinyint NULL ,
        NumerSemestru smallint ,
        DataRozpoczecia date NULL ,
	GodzinaRozpoczecia time(0) NULL ,
	CzasTrwania smallint NULL ,
	PlanNaPoniedzialek bit NOT NULL ,
	PlanNaWtorek bit NOT NULL ,
	PlanNaSrode bit NOT NULL ,
	PlanNaCzwartek bit NOT NULL ,
	PlanNaPiatek bit NOT NULL ,
	PlanNaSobote bit NOT NULL 
)
GO

CREATE TABLE Wydzialy (
	IDWydzialu int NOT NULL ,
	NazwaWydzialu nvarchar (50) NULL ,
	KierownikWydzialu int NULL 
)
GO

CREATE TABLE Wykladowcy (
	IDPracownika int NOT NULL ,
	Tytul nvarchar (50) NULL ,
	Status nvarchar (15) NULL ,
	Etat bit NOT NULL 
)
GO

CREATE TABLE Dziedziny_wykladowcow (
	IDPracownika int NOT NULL ,
	IDDziedziny nvarchar (10) NOT NULL 
)
GO

CREATE TABLE Zajecia_wykladowcow (
	IDZajec int NOT NULL ,
	IDPracownika int NOT NULL 
)
GO

CREATE TABLE Przedmioty_wykladowcow (
	IDPracownika int NOT NULL ,
	IDPrzedmiotu int NOT NULL ,
	OcenaBieglosci real NULL 
)
GO

CREATE TABLE Kierunki (
        IDKierunku int NOT NULL ,
        Kierunek nvarchar (20) NULL 
        )
GO

CREATE TABLE Pracownicy (
	IDPracownika int NOT NULL ,
	ImiePracownika nvarchar (25) NULL ,
	NazwiskoPracownika nvarchar (25) NULL ,
	AdresPracownika nvarchar (50) NULL ,
	MiastoPracownika nvarchar (30) NULL ,
	StanZamPracownika nvarchar (2) NULL ,
	KodPocztowyPracownika nvarchar (5) NULL ,
	NumKierPracownika nvarchar (5) NULL ,
	TelefonPracownika nvarchar (8) NULL ,
	Wynagrodzenie money NULL ,
	DataZatrudnienia date NULL ,
	Stanowisko nvarchar (50) NULL 
)
GO

CREATE TABLE Status_zajec_studenta (
	StatusZajec int NOT NULL ,
	OpisStatusuZajec nvarchar (50) NULL 
)
GO

CREATE TABLE Grafik_studenta (
	IDStudenta int NOT NULL ,
	IDZajec int NOT NULL ,
	StatusZajec int NULL ,
	Ocena real NULL 
)
GO

CREATE TABLE Studenci (
	IDStudenta int NOT NULL ,
	ImieStudenta nvarchar (25) NULL ,
	NazwiskoStudenta nvarchar (25) NULL ,
	AdresStudenta nvarchar (50) NULL ,
	MiastoStudenta nvarchar (30) NULL ,
	StanZamStudenta nvarchar (2) NULL ,
	KodPocztowyStudenta nvarchar (5) NULL ,
	NumKierStudenta nvarchar (5) NULL ,
	TelefonStudenta nvarchar (8) NULL ,
	DataUrodzStudenta date NULL ,
	PlecStudenta nvarchar (1) NULL,
	StanCywilnyStudenta nvarchar (1) NULL, 
        KierunekStudiow int NULL 
)
GO

CREATE TABLE Przedmioty (
	IDPrzedmiotu int NOT NULL ,
	IDDziedziny nvarchar (10) NULL ,
	KodPrzedmiotu nvarchar (8) NULL ,
	NazwaPrzedmiotu nvarchar (50) NULL ,
    Wymagania nvarchar (8) NULL ,
	OpisPrzedmiotu ntext NULL , 
	SzacWielkoscGrupy smallint NOT NULL 
)
GO

CREATE TABLE ztblMacierzPlci (
	Plec nvarchar (1) NOT NULL ,
        Mezczyzna smallint NULL ,
        Kobieta smallint NULL
) 
GO

CREATE TABLE ztblOcenyLiterowe ( 
	OcenaLiterowa nvarchar (3) NOT NULL ,
        PunktowyProgDolny real NULL ,
        PunktowyProgGorny real NULL 
)
GO

CREATE TABLE ztblMacierzStanuCywilnego (
	StanCywilny nvarchar (1) NOT NULL , 
	Mlzn smallint NULL ,
        Smtn smallint NULL ,
        Wdw smallint NULL ,
        Rzwd smallint NULL  
)
GO

CREATE TABLE ztblOcenyWykladowcow ( 
        OpisOcenyWykladowcy nvarchar (12) NULL ,
        ProgDolnyOceny float (53) NOT NULL ,
        ProgGornyOceny float (53) NULL 
)
GO

CREATE TABLE ztblDniSemestru (
        NrSemestru smallint NOT NULL ,
        DataWSemestrze date NOT NULL ,
        DzienTygodnia nvarchar (15) NULL
)
GO

CREATE TABLE ztblNumeryKolejne ( 
        NrKolejny int NOT NULL
)
GO

ALTER TABLE Budynki ADD 
	CONSTRAINT Elevator_Access_Default DEFAULT (0) FOR Winda,
	CONSTRAINT Site_Parking_Available_Default DEFAULT (0) FOR Parking,
	CONSTRAINT Budynki_PK PRIMARY KEY   
	(
		KodBudynku
	)  
GO

 CREATE  INDEX LiczbaKondygnacji ON Budynki(LiczbaKondygnacji)
GO

ALTER TABLE Dziedziny ADD 
	CONSTRAINT Cat_Department_ID_Default DEFAULT (0) FOR IDWydzialu,
	CONSTRAINT Dziedziny_PK PRIMARY KEY   
	(
		IDDziedziny
	)  
GO

 CREATE  INDEX IDWydzialu ON Dziedziny(IDWydzialu)
GO

ALTER TABLE Sale ADD 
	CONSTRAINT Phone_Available_Default DEFAULT (0) FOR DostTelefonu, 
	CONSTRAINT Capacity_Default DEFAULT (0) FOR LiczbaMiejsc, 
	CONSTRAINT Sale_PK PRIMARY KEY   
	(
		IDSali
	)  
GO

 CREATE  INDEX NumerBudynku ON Sale(KodBudynku)
GO

ALTER TABLE Zajecia ADD 
	CONSTRAINT C_Subject_ID_Default DEFAULT (0) FOR IDPrzedmiotu,
	CONSTRAINT C_Class_Room_ID_Default DEFAULT (0) FOR IDSali,
	CONSTRAINT Creidts_Default DEFAULT (0) FOR PunktyEdukacyjne,
	CONSTRAINT Duration_Default DEFAULT (0) FOR CzasTrwania,
	CONSTRAINT Monday_Schedule_Default DEFAULT (0) FOR PlanNaPoniedzialek,
	CONSTRAINT Tuesday_Schedule_Default DEFAULT (0) FOR PlanNaWtorek,
	CONSTRAINT Wednesday_Schedule_Default DEFAULT (0) FOR PlanNaSrode,
	CONSTRAINT Thursday_Schedule_Default DEFAULT (0) FOR PlanNaCzwartek,
	CONSTRAINT Friday_Schedule_Default DEFAULT (0) FOR PlanNaPiatek,
	CONSTRAINT Saturday_Schedule_Default DEFAULT (0) FOR PlanNaSobote,
	CONSTRAINT Zajecia_PK PRIMARY KEY   
	(
		IDZajec
	)  
GO

 CREATE  INDEX IDPrzedmiotu ON Zajecia(IDPrzedmiotu)
GO

 CREATE  INDEX IDSali ON Zajecia(IDSali)
GO

ALTER TABLE Wydzialy ADD 
	CONSTRAINT Dept_Chair_Default DEFAULT (0) FOR KierownikWydzialu,
	CONSTRAINT Wydzialy_PK PRIMARY KEY  
	(
		IDWydzialu
	)  
GO

 CREATE  INDEX PracownicyWydzialy ON Wydzialy(KierownikWydzialu)
GO

ALTER TABLE Wykladowcy ADD 
	CONSTRAINT Tenured_Default DEFAULT (0) FOR Etat,
	CONSTRAINT Wykladowcy_PK PRIMARY KEY   
	(
		IDPracownika
	)  
GO

ALTER TABLE Dziedziny_wykladowcow ADD 
	CONSTRAINT FC_Category_ID_Default DEFAULT ('KSI') FOR IDDziedziny,
	CONSTRAINT Dziedziny_wykladowcow_PK PRIMARY KEY   
	(
		IDPracownika,
		IDDziedziny
	)  
GO

 CREATE  INDEX DziedzinyWykladowcy_Dziedziny ON Dziedziny_wykladowcow(IDDziedziny)
GO

 CREATE  INDEX WykladowcyWykladowcy_Dziedziny ON Dziedziny_wykladowcow(IDPracownika)
GO

ALTER TABLE Zajecia_wykladowcow ADD 
	CONSTRAINT Zajecia_wykladowcow_PK PRIMARY KEY   
	(
		IDZajec,
		IDPracownika
	)  
GO

 CREATE  INDEX ZajeciaWykladowcyZajecia ON Zajecia_wykladowcow(IDZajec)
GO

 CREATE  INDEX PracownicyWykladowcyZajecia ON Zajecia_wykladowcow(IDPracownika)
GO

ALTER TABLE Przedmioty_wykladowcow ADD 
	CONSTRAINT FS_Staff_ID_Default DEFAULT (0) FOR IDPracownika,
	CONSTRAINT FS_Subject_ID_Default DEFAULT (0) FOR IDPrzedmiotu,
	CONSTRAINT Proficiency_Rating_Default DEFAULT (0) FOR OcenaBieglosci,
	CONSTRAINT Przedmioty_wykladowcow_PK PRIMARY KEY   
	(
		IDPracownika,
		IDPrzedmiotu
	)  
GO

 CREATE  INDEX WykladowcyWykladowcyPrzedmioty ON Przedmioty_wykladowcow(IDPracownika)
GO

 CREATE  INDEX PrzedmiotyWykladowcyPrzedmioty ON Przedmioty_wykladowcow(IDPrzedmiotu)
GO

ALTER TABLE Kierunki ADD
        CONSTRAINT Kierunki_PK PRIMARY KEY
        (
               IDKierunku
        )
GO

ALTER TABLE Pracownicy ADD 
	CONSTRAINT Pracownicy_PK PRIMARY KEY   
	(
		IDPracownika
	)  
GO

 CREATE  INDEX KodPocztowyPracownika ON Pracownicy(KodPocztowyPracownika)
GO

 CREATE  INDEX NumKierStudenta ON Pracownicy(NumKierPracownika)
GO

ALTER TABLE Status_zajec_studenta ADD 
	CONSTRAINT Class_Status_Default DEFAULT (0) FOR StatusZajec,
	CONSTRAINT Status_zajec_studenta_PK PRIMARY KEY   
	(
		StatusZajec
	)  
GO

ALTER TABLE Grafik_studenta ADD 
	CONSTRAINT SS_Class_Status_Default DEFAULT (0) FOR StatusZajec,
	CONSTRAINT Grade_Default DEFAULT (0) FOR Ocena,
	CONSTRAINT Grafik_studenta_PK PRIMARY KEY   
	(
		IDStudenta,
		IDZajec
	)  
GO

 CREATE  INDEX ZajeciaGrafikStudenta ON Grafik_studenta(IDZajec)
GO

 CREATE  INDEX StudenciZajeciaStatusGrafikStudenta ON Grafik_studenta(StatusZajec)
GO

 CREATE  INDEX StudenciGrafikStudenta ON Grafik_studenta(IDStudenta)
GO

ALTER TABLE Studenci ADD 
	CONSTRAINT Studenci_PK PRIMARY KEY   
	(
		IDStudenta
	)  
GO

 CREATE  INDEX NumKierStudenta ON Studenci(NumKierStudenta)
GO

 CREATE  INDEX KodPocztowyStudenta ON Studenci(KodPocztowyStudenta)
GO

ALTER TABLE Przedmioty ADD 
	CONSTRAINT Subject_ID_Default DEFAULT (0) FOR IDPrzedmiotu,
        CONSTRAINT Subject_PreReq_Default DEFAULT (NULL) FOR Wymagania, 
	CONSTRAINT Subject_Est_Class_Size DEFAULT (0) For SzacWielkoscGrupy, 
	CONSTRAINT Przedmioty_PK PRIMARY KEY   
	(
		IDPrzedmiotu
	)  
GO

 CREATE  INDEX IDDziedziny ON Przedmioty(IDDziedziny)
GO

 CREATE  UNIQUE  INDEX KodPrzedmiotu ON Przedmioty(KodPrzedmiotu)
GO

ALTER TABLE ztblMacierzPlci ADD 
        CONSTRAINT ztblMacierzPlci_PK PRIMARY KEY 
        (
               Plec
        )
GO

ALTER TABLE ztblOcenyLiterowe ADD 
        CONSTRAINT ztblOcenyLiterowe_PK PRIMARY KEY
        (
                OcenaLiterowa 
        )
GO

ALTER TABLE ztblMacierzStanuCywilnego ADD 
        CONSTRAINT ztblMacierzStanuCywilnego_PK PRIMARY KEY
        (
                StanCywilny 
        )
GO

ALTER TABLE ztblOcenyWykladowcow ADD 
	CONSTRAINT ztblOcenyWykladowcow_PK PRIMARY KEY 
	(
		ProgDolnyOceny 
	)
GO

ALTER TABLE ztblDniSemestru ADD 
	CONSTRAINT ztblDniSemestru_PK PRIMARY KEY 
	( 
		NrSemestru ,
                DataWSemestrze 
	)
GO

ALTER TABLE ztblNumeryKolejne ADD 
	CONSTRAINT Sequence_Default DEFAULT (0) FOR NrKolejny,
	CONSTRAINT ztblNumeryKolejne_PK PRIMARY KEY 
	(
		NrKolejny 
	)
GO

ALTER TABLE Dziedziny ADD 
	CONSTRAINT Dziedziny_FK00 FOREIGN KEY 
	(
		IDWydzialu
	) REFERENCES Wydzialy (
		IDWydzialu
	)
GO

ALTER TABLE Sale ADD 
	CONSTRAINT Sale_FK00 FOREIGN KEY 
	(
		KodBudynku
	) REFERENCES Budynki (
		KodBudynku
	)
GO

ALTER TABLE Zajecia ADD 
	CONSTRAINT Zajecia_FK00 FOREIGN KEY 
	(
		IDSali
	) REFERENCES Sale (
		IDSali
	),
	CONSTRAINT Zajecia_FK01 FOREIGN KEY 
	(
		IDPrzedmiotu
	) REFERENCES Przedmioty (
		IDPrzedmiotu
	)
GO

ALTER TABLE Wydzialy ADD 
	CONSTRAINT Wydzialy_FK00 FOREIGN KEY 
	(
		KierownikWydzialu
	) REFERENCES Pracownicy (
		IDPracownika
	)
GO

ALTER TABLE Wykladowcy ADD 
	CONSTRAINT Wykladowcy_FK00 FOREIGN KEY 
	(
		IDPracownika
	) REFERENCES Pracownicy (
		IDPracownika
	)
GO

ALTER TABLE Dziedziny_wykladowcow ADD 
	CONSTRAINT Dziedziny_wykladowcow_FK00 FOREIGN KEY 
	(
		IDDziedziny
	) REFERENCES Dziedziny (
		IDDziedziny
	),
	CONSTRAINT Dziedziny_wykladowcow_FK01 FOREIGN KEY 
	(
		IDPracownika
	) REFERENCES Wykladowcy (
		IDPracownika
	)
GO

ALTER TABLE Zajecia_wykladowcow ADD 
	CONSTRAINT Zajecia_wykladowcow_FK00 FOREIGN KEY 
	(
		IDZajec
	) REFERENCES Zajecia (
		IDZajec
	),
	CONSTRAINT Zajecia_wykladowcow_FK01 FOREIGN KEY 
	(
		IDPracownika
	) REFERENCES Pracownicy (
		IDPracownika
	),
        CONSTRAINT Zajecia_wykladowcow_FK02 FOREIGN KEY
	(
		IDPracownika
	) REFERENCES Wykladowcy (
		IDPracownika
	)
GO

ALTER TABLE Przedmioty_wykladowcow ADD 
	CONSTRAINT Przedmioty_wykladowcow_FK00 FOREIGN KEY 
	(
		IDPracownika
	) REFERENCES Wykladowcy (
		IDPracownika
	),
	CONSTRAINT Przedmioty_wykladowcow_FK01 FOREIGN KEY 
	(
		IDPrzedmiotu
	) REFERENCES Przedmioty (
		IDPrzedmiotu
	)
GO

ALTER TABLE Studenci ADD
        CONSTRAINT Studenci_FK00 FOREIGN KEY
        (
                KierunekStudiow
        ) REFERENCES Kierunki (
                IDKierunku
        )
GO

ALTER TABLE Grafik_studenta ADD 
	CONSTRAINT Grafik_studenta_FK00 FOREIGN KEY 
	(
		IDZajec
	) REFERENCES Zajecia (
		IDZajec
	),
	CONSTRAINT Grafik_studenta_FK01 FOREIGN KEY 
	(
		StatusZajec
	) REFERENCES Status_zajec_studenta (
		StatusZajec
	),
	CONSTRAINT Grafik_studenta_FK02 FOREIGN KEY 
	(
		IDStudenta
	) REFERENCES Studenci (
		IDStudenta
	)
GO

ALTER TABLE Przedmioty ADD 
	CONSTRAINT Przedmioty_FK00 FOREIGN KEY 
	(
		IDDziedziny
	) REFERENCES Dziedziny (
		IDDziedziny
	),
        CONSTRAINT Przedmioty_FK01 FOREIGN KEY
	(
		Wymagania
	) REFERENCES Przedmioty (
		KodPrzedmiotu
	)
GO

